/////////////////////////////////////////////////////////////////////////////
// raysView.cpp : implementation of the CRaysView class
//

#include "Rays.h"
#include "RaysView.h"


/////////////////////////////////////////////////////////////////////////////
// CRaysView construction/destruction

CRaysView::CRaysView() : BView( BRect( 100, 100, 200, 200 ), "Rays", B_FOLLOW_ALL_SIDES,  B_WILL_DRAW )
{
	OutImg = new BBitmap( BRect( 0.0, 0.0, 100, 100 ), B_RGB_32_BIT );
}

CRaysView::CRaysView( int TopX, int TopY, int BotX, int BotY ) : BView( BRect( TopX, TopY, BotX, BotY ), "Rays", B_FOLLOW_ALL_SIDES,  B_WILL_DRAW )
{
	OutImg = new BBitmap( BRect( 0, 0, (BotX - TopX), (BotY - TopY) + 1 ), B_RGB_32_BIT );
}

CRaysView::~CRaysView()
{
	// delete the output image..
	
	if( OutImg )
		delete OutImg;
}

////////////////////////////////////////////////////////////////////////////
// Called on a refresh window..

void CRaysView::Draw( BRect UpdateRect )
{
	DrawBitmap( OutImg );
}

#define BYTES_PER_PIXEL 	4

void CRaysView::Clear()
{
	BRect MyRect = Frame();

	int Row;
	for( Row = 0; Row < MyRect.bottom - MyRect.top; Row++ )
	{
		int Col;
		for( Col = 0; Col < MyRect.right - MyRect.left; Col++ )
		{

			// Offset into the image.
			int Offset = (int)(Row * (MyRect.right - MyRect.left + 1) * BYTES_PER_PIXEL ) + abs((Col -1) * BYTES_PER_PIXEL);
	
			// Pack the pixel.
			int32 RGBValue = 0;

			// Set value.
			OutImg->SetBits( &RGBValue, 1, Offset, B_RGB_32_BIT );
	
		}
	}
}


void CRaysView::MessageReceived( BMessage *message )
{
	BView::MessageReceived( message );
}

