//////////////////////////////////////////////////////////////////////
// Vector.h: interface for the CVector class.
//


#ifndef VECTOR_H
#define VECTOR_H

class CVector  
{
public:
	double Length();
	CVector operator*(double Val );
	double GetZ();
	double GetY();
	double GetX();
	 CVector( const CVector& OtherVector );
	 CVector( float x1, float y1, float z1 );
	CVector RevRotate( float cos1, float sin1, float cos2, float sin2 );
	CVector Rotate( float cos1, float sin1, float cos2, float sin2 );
	CVector Max( CVector Arg );
	CVector Min( CVector Arg );
	CVector operator~();
	CVector operator^( CVector& Arg );
	double operator%( CVector& Arg );
	CVector operator/( float );
	CVector operator*( float Arg );
	CVector operator*( CVector& Arg );
	CVector operator=( const CVector& Arg );
	CVector operator-();
	CVector operator-( CVector& Arg );
	CVector operator+( CVector& Arg );
	CVector();

private:
	double x, y, z;
};

#endif
