//////////////////////////////////////////////////////////////////////
// Vector.cpp: implementation of the CVector class.
// Some funny conventions..
//	% is overloaded as dot product.
//	^ is overloaded as cross product
//	~ is overloaded as Normalise
//////////////////////////////////////////////////////////////////////

#include "Vector.h"				// Declaration of this class,
#include <math.h>				// Standard C maths.

#define min( x, y )  ? ( x > y ) x : y 

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////
// Default Constructor.


CVector::CVector()
{
	x = y = z = 0.0f;
}


////////////////////////////////////////////////////
// Vector plus vector...


CVector CVector::operator+(CVector& Arg)
{		
	CVector RetVal;

	RetVal.x = x = x + Arg.x;
	RetVal.y = y = y + Arg.y;
	RetVal.z = z = z + Arg.z;

	return RetVal;
}

////////////////////////////////////////////////////
// Vector minus vector..


CVector CVector::operator-(CVector& Arg)
{
	CVector RetVal;

	RetVal.x = x = x - Arg.x;
	RetVal.y = y = y - Arg.y;
	RetVal.z = z = z - Arg.z;

	return RetVal;
}

////////////////////////////////////////////////////
//	negate vector..


CVector CVector::operator-()
{
	CVector RetVal;

	RetVal.x = x = -x;
	RetVal.y = y = -y;
	RetVal.z = z = -z;

	return RetVal;

}

////////////////////////////////////////////////////
// Assignment.


CVector CVector::operator=(const CVector& Arg)
{
	CVector RetVal;

	x = Arg.x;
	y = Arg.y;
	z = Arg.z;

	RetVal.x = Arg.x;
	RetVal.y = Arg.y;
	RetVal.z = Arg.z;

	return RetVal;

}

////////////////////////////////////////////////////
// Vector times vector.


CVector CVector::operator*(CVector & Arg)
{
	CVector RetVal;

	RetVal.x = x = x * Arg.x;
	RetVal.y = y = y * Arg.y;
	RetVal.z = z = z * Arg.z;

	return RetVal;

}

////////////////////////////////////////////////////
// Vector times a float.


CVector CVector::operator*( float Arg )
{
	CVector RetVal;
	
	RetVal.x = x = x * Arg;
	RetVal.y = y = y * Arg;
	RetVal.z = z = z * Arg;

	return RetVal;
}


////////////////////////////////////////////////////
//	Vector divided by float.


CVector CVector::operator /(float Arg )
{
	CVector RetVal;

	RetVal.x = x = x / Arg;
	RetVal.y = y = y / Arg;
	RetVal.z = z = z / Arg;

	return RetVal;
}

////////////////////////////////////////////////////
// Dot product..
//
// Angle between vectors.
// If both vectors are unit vectors then result is 
// the cosine angle between them..
/// See a maths or 3D text..

double CVector::operator%(CVector& Arg )
{
	double RetVal;

	RetVal = x * Arg.x + y * Arg.y + z * Arg.z;

	return RetVal;
}

////////////////////////////////////////////////////
// Cross product..
//
//		
//       ^
//		/|\  v1 
//		 |  /#\
//		 |/	   \
//		  \	   /
//		    \#/
//			 v2
//	A vector perpendicular to plane formed by the two vectors..
//
CVector CVector::operator ^(CVector & Arg)
{
	CVector RetVal;

	RetVal.x = x = y * Arg.z - z * Arg.y;
	RetVal.y = y = z * Arg.x - x * Arg.z;
	RetVal.z = z = x * Arg.y - y * Arg.x;

	return RetVal;
}


////////////////////////////////////////////////////
// Normalise..


CVector CVector::operator ~()
{
	CVector RetVal;

	double l;
	l = *this % *this;
	l = (float) sqrt( l );
	RetVal.x = x = x / l;
	RetVal.y = y = y / l;
	RetVal.z = z = z / l;

	return RetVal;
}

////////////////////////////////////////////////////
// The Min of this and another vector


CVector CVector::Min(CVector Arg)
{
	CVector RetVal = *this;
	~Arg;		// Normalise
	~RetVal;	// Normalize
	RetVal = (RetVal.Length() < Arg.Length()) ? RetVal : Arg;
	return RetVal;
}

////////////////////////////////////////////////////
// The Max of this and another vector

CVector CVector::Max(CVector Arg)
{
	CVector RetVal = *this;
	~Arg;		// Normalise
	~RetVal;	// Normalize
	RetVal = (RetVal.Length() > Arg.Length()) ? RetVal : Arg;
	return RetVal;
}

////////////////////////////////////////////////////
// Rotation..

CVector CVector::Rotate(float cos1, float sin1, float cos2, float sin2)
{
	CVector RetVal,	Temp;

	RetVal.x = x * cos1 + z * -sin1;
	Temp.y = y;
	Temp.z = x * sin1 + z * cos1;
	RetVal.y = Temp.y * - cos2 + Temp.z * sin2;
	RetVal.z = Temp.y * - sin2 + Temp.z * -cos2;

	return RetVal;
}

////////////////////////////////////////////////////
// Reverse rotation..


CVector CVector::RevRotate(float cos1, float sin1, float cos2, float sin2)
{
	CVector RetVal,	Temp;

	RetVal.y = y * cos2 + z * -sin2;
	Temp.x = x;
	Temp.z = x * sin1 + z * cos1;
	RetVal.x = Temp.x * - cos1 + Temp.z * sin1;
	RetVal.z = Temp.x * - sin1 + Temp.z * -cos1;

	return RetVal;
}


////////////////////////////////////////////////////
// Constructor..

CVector::CVector(float x1, float y1, float z1)
{
	x = x1;
	y = y1;
	z = z1;
}



///////////////////////////////////////////////////
// Assignment op ergo require copy constructor..

CVector::CVector(const CVector& OtherVector)
{
	x = OtherVector.x;
	y = OtherVector.y;
	z = OtherVector.z;
}


/////////////////////////////////////////////////////
// Get at individual values..
//

double CVector::GetX()
{
	return x;
}

double CVector::GetY()
{
	return y;
}

double CVector::GetZ()
{
	return z;
}

/////////////////////////////////////////////////////
// Vector times a double..

CVector CVector::operator *(double Val)
{
	CVector RetVal; 
	RetVal.x  = x = x * Val;
	RetVal.y = y = y * Val;
	RetVal.z = z = z * Val;
	return RetVal;
}


/////////////////////////////////////////////////////
// Length from an orgin.
//

double CVector::Length()
{
	return sqrt( x * x + y * y + z * z ); 
}


