// Sphere.h: interface for the CSphere class.
//
//////////////////////////////////////////////////////////////////////


#include "SceneObject.h"
#include "Vector.h"	// Added by ClassView

class CSphere : public CSceneObject  
{

public:
	// Operations.
	virtual CVector Normal( CVector Point );				// Calc Normal for this object type.
	virtual double Intersect( Ray TheRay );					// Calc intersection.for this object type.

	/// Construction / Destruction.
	CSphere( float x, float y, float z, float radius );
	CSphere();
	virtual ~CSphere();

private:
	float radius;
	CVector Center;
};


