//////////////////////////////////////////////////////////////////////
// Sphere.cpp: implementation of the CSphere class.
//

#include <math.h>
#include "SceneObject.h"
#include "Sphere.h"
#include "Vector.h"

// Constants/Macros for this file..
#define EPSILON	1e-3
#define SQUARE( X ) ((X) * (X))



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSphere::CSphere()
{
	// What should this default to ?
	Center = CVector( 0.0f,0.0f,0.0f );
	radius = 0.0f;
}

CSphere::~CSphere()
{
}

CSphere::CSphere(float x, float y, float z, float Radius )
{
	Center = CVector( x, y, z );
	radius = Radius;
}


//////////////////////////////////////////////////////////////////////
// Substitue the 3D parametric equation of a line into the formula
// for a shpere. See Maths books for details..
// Doocument this...

double CSphere::Intersect(Ray TheRay)
{

	double B_Term, C_Term, Discrim, T0, T1;

	// Calculate B and C values.. See maths text..
	B_Term = 2 * ( TheRay.Direction.GetX() * (TheRay.Origin.GetX() - Center.GetX() ) +
				TheRay.Direction.GetY() * (TheRay.Origin.GetY() - Center.GetY() ) +
				TheRay.Direction.GetZ() * (TheRay.Origin.GetZ() - Center.GetZ() ) );

	C_Term = SQUARE( TheRay.Origin.GetX() - Center.GetX()) +
			 SQUARE( TheRay.Origin.GetY() - Center.GetY()) +
			 SQUARE( TheRay.Origin.GetZ() - Center.GetZ())	- SQUARE( radius );

	Discrim = SQUARE( B_Term ) - 4 * C_Term;

/*	
	if( Discrim <= EPSILON )
		return 0.0;
*/
	Discrim = sqrt( Discrim );
	
	T0 = (-B_Term - Discrim) * 0.5;

	if( T0 > EPSILON )
		return T0;

	T1 = (-B_Term + Discrim ) * 0.5;
	if( T1 > EPSILON )
		return T1;
		
	return 0.0;
}


//////////////////////////////////////////////////////////////////////
// Normal calculation for spheres. 

CVector CSphere::Normal(CVector Point)
{
	CVector RetVal;

	RetVal = Point - Center;					// Point 
	~RetVal;									// Normalise operator, need unit vector.

	return RetVal;
}



