////////////////////////////////////////////////////////////////////////////
// RaysWnd..
//

#ifndef RAYWND_H
#define RAYWND_H

#include "RaysView.h"
#include "MultiRender.h"

// Messages..
#define MOPTION_RENDER	'mrd'
#define MOPTION_OPEN	'mop'
#define MOPTION_SAVE	'msv'
#define MOPTION_QUIT	'mqt'
#define MOPTION_ABOUT	'mab'

#include <Window.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <FilePanel.h>
#include <Region.h>
#include <Alert.h>
#include <Path.h>
#include <File.h>
#include <BitmapStream.h>

class RaysWnd : public BWindow
{
private:
	CRaysView *MainView;		// View..
	BMenuBar *MainMenu;			// Menu bar.
	BMenu *RenderMenu;
	BMenuItem *RenderItem;

	BMenu *FileMenu;
	BMenuItem *OpenItem;
	BMenuItem *SaveItem;
	BMenuItem *QuitItem;
	
	BMenu *WindowMenu;

	BMenu *HelpMenu;
	BMenuItem *AboutItem;

	BFilePanel *OpenDialog;
	BFilePanel *SaveDialog;
	
	void SaveFile( BMessage *Message );
	void LoadFile( BMessage *Message );
	
		
public:
	CMultiRender *RenderContext;

	RaysWnd( int left, int top, int right, int bottom );
	RaysWnd();					// Construct..
	~RaysWnd();					// Release..
	
	// Message hooks..	
	virtual bool QuitRequested();
	virtual void MessageReceived( BMessage *message );	
};

#endif


