///////////////////////////////////////////////////////
// Window class.

#include "RaysWnd.h"		// Declaration for this class.
#include "MultiRender.h"	// Render context.
#include <TranslatorRoster.h>
#include <stdio.h>

#include "Plane.h"
#include "Colour.h"

#define MENU_SIZE		14

#define TOP_X	50
#define TOP_Y	50
#define BOT_X	400
#define BOT_Y	300


///////////////////////////////////////////////////////
// Constructor.

RaysWnd::RaysWnd( int left, int top, int right, int bottom ) : BWindow(BRect( left, top, right, bottom ),  "Rays", B_TITLED_WINDOW, B_NOT_ZOOMABLE | B_NOT_RESIZABLE )
{
	RaysWnd();		
}

RaysWnd::RaysWnd() : BWindow(BRect( TOP_X, TOP_Y, BOT_X, BOT_Y),  "Rays", B_TITLED_WINDOW, B_NOT_ZOOMABLE | B_NOT_RESIZABLE )
{
	MainView = NULL;
	BRect TempRect;							
	TempRect = Bounds();			// Get window extents.

	////////////////////////////
	// Create view.	

	MainView = new CRaysView( TempRect.left, TempRect.top + MENU_SIZE + 5, TempRect.right, TempRect.bottom   );	// Construct a view.. 
	if( MainView )					// If possible, add view to window..
		AddChild( MainView );		
	
	
	///////////////////////////
	// Add menus  

	// Create Main menu bar.
	TempRect.bottom = TempRect.top + MENU_SIZE;			
	MainMenu = new BMenuBar( TempRect, "Mainmenu" );

	// Create file menu.
	FileMenu = new BMenu( "File", B_ITEMS_IN_COLUMN );
	OpenItem = new BMenuItem( "Open Script", new BMessage( MOPTION_OPEN ) );
	SaveItem = new BMenuItem( "Save Image", new BMessage( MOPTION_SAVE ) );
	QuitItem = new BMenuItem( "Quit", new BMessage( MOPTION_QUIT ) );

//	OpenItem->SetEnabled( false );
	SaveItem->SetEnabled( false );	
	
	// Attach items to file menu.
	if( FileMenu && OpenItem && SaveItem && QuitItem )
	{
		FileMenu->AddItem( OpenItem );
		FileMenu->AddItem( SaveItem );
		FileMenu->AddItem( QuitItem );
	}
	else
	{
		exit( 0 );
	}

	// Create Window menu.
	WindowMenu = new BMenu( "Window", B_ITEMS_IN_COLUMN );

	// Create render menu.
	RenderMenu = new BMenu("Go", B_ITEMS_IN_COLUMN);
	RenderItem = new BMenuItem( "Render", new BMessage( MOPTION_RENDER ));

	// Attatch item to render menu.
	if( RenderMenu )
		RenderMenu->AddItem( RenderItem );

	// Create help
	HelpMenu = new BMenu( "Help", B_ITEMS_IN_COLUMN );
	AboutItem = new BMenuItem( "About", new BMessage( MOPTION_ABOUT ) );
	HelpMenu->AddItem( AboutItem );

	// Attach menus to menu bar..
	if( MainMenu )
	{
		MainMenu->AddItem( FileMenu );
		MainMenu->AddItem( RenderMenu );
//		MainMenu->AddItem( WindowMenu );
		MainMenu->AddItem( HelpMenu );

		// Add menu bar to the application.
		AddChild( MainMenu );
	}

	/////////////////////////////////
	// Construct dialog boxes..
	
	OpenDialog = new BFilePanel( B_OPEN_PANEL, new BMessenger( this ), NULL );
	SaveDialog = new BFilePanel( B_SAVE_PANEL, new BMessenger( this ), NULL );
	
	RenderContext = new CMultiRender();
	
}


///////////////////////////////////////////////////////
// Destructor, 
// 

RaysWnd::~RaysWnd() 
{
	// Have to remove the view from the window b4 deletion.
	if( MainView->RemoveSelf())		
			delete MainView;

	// Delete all the object created in this class.
	if( OpenDialog )
		delete OpenDialog;
		
	if( SaveDialog )
		delete SaveDialog;


	///////////////////////////////////////////////////////////
	// In general objects that are attatched to other
	// objects will be deleted for you..
	// Do not need to delete the menu items as the menus they
	// are attatched to delete them.
	// Menus are attached to the main view and the view is attached
	// to the window..
	
	if( RenderContext )
		delete RenderContext;
}

///////////////////////////////////////////////////////
// Quit requested. let the application know about it..

extern BApplication *be_app;
#include "Rays.h"

bool RaysWnd::QuitRequested()
{
	// Window (and application) about to close..
	( (CRaysApp *)be_app )->PostMessage( B_QUIT_REQUESTED );	
	
	// Message handled.	
	return( true );								
}



///////////////////////////////////////////////////////
// Message handler for this window..
// All the BMessages created in the constructor 
// end up here when the user selects them.

void RaysWnd::MessageReceived( BMessage *Message )
{
	CRaysDoc *pDoc = new CRaysDoc();	

	// Get dimentions to pass on to render context.	
	BRegion ClientRegion;
	MainView->GetClippingRegion( &ClientRegion );
	unsigned int nWidth = ClientRegion.Frame().IntegerWidth();
	unsigned int nHeight = ClientRegion.Frame().IntegerHeight();

////////////////////////
// TODO: handle B_SAVE_REQUESTED, B_OPEN_REQUESTED and B_CANCEL_REQUESTED messages
// from the dialog boxes..

	BAlert *AboutAlert;
	
	switch( Message->what )
	{
								// Create and launch a render.
		case MOPTION_RENDER: 	SetTitle( "Rendering" );	
								// RenderItem->SetEnabled( false );
								
								if( RenderContext )
									RenderContext->Go( pDoc, nWidth, nHeight, this );
								else						
									RenderItem->SetEnabled( true );
								SetTitle( "Rays" );
								break;	
							
								// Open	
		case MOPTION_OPEN:		OpenDialog->Show();
								break;	
	
								// Save
		case MOPTION_SAVE:		SaveDialog->Show();						
								break;

								// Exit application.									
		case MOPTION_QUIT:		QuitRequested();	
								break;


		case B_CANCEL:			//Message->FindString("name", (const char **) &name); 
								break;
								
		case B_SAVE_REQUESTED:
								SaveFile( Message );
								break;
	
				
		case B_REFS_RECEIVED:	
								LoadFile( Message );
								break;

		case MOPTION_ABOUT:		AboutAlert = new BAlert( "About", "..by Regan Russell \n www.users.bigpond.net.au/rrussell/", "OK" );
								AboutAlert->Go();
								
								
																
		default:
								BWindow::MessageReceived( Message );
	}
}

////////////////////////////////////////////////////////////////////////
// LoadFile 
//
#ifndef __INTEL__
int yyparse();
#else
extern "C" int yyparse();
#endif

void RaysWnd::LoadFile( BMessage *Message )
{
	entry_ref the_ref;

	if( Message->FindRef( "refs", &the_ref ) >= B_OK )
	{
		BEntry Entry( &the_ref, true );
		BPath Path;
		Entry.GetPath( &Path );

		FILE *fp;
		fp = fopen( Path.Path(), "r" );
		if( fp )	// Can be opened ?
		{
			fclose( fp );
			RenderContext->EmptyScene();		// clear scene..

			RenderContext->Background = CColour( (unsigned char) 175, (unsigned char) 200, (unsigned char) 255 );

			// Set a default floor.
			CSceneObject *Floor = new Plane( 0, 1, 0, -50 );
			Floor->SetColour( CColour( (unsigned char) 150, (unsigned char) 175, (unsigned char) 150 ) );
			Floor->SetProperties( 0.3, 0.7, 20.0, 0.9, 100.0, 0.65 );
			RenderContext->SceneList->AddItem( Floor );
			
			freopen( Path.Path(), "r", stdin );
			yyparse();
		}
	}

}

/////////////////////////////////////////////////////////////////////////////////
//
//
//

void RaysWnd::SaveFile( BMessage *Message )
{
	entry_ref the_ref;
	const char *name;


	if( Message->FindRef( "directory", &the_ref ) < B_OK )
	{
	}
	else
	{
		if( Message->FindString( "name", (const char **) &name ) < B_OK )
		{
		}
		else
		{	

			BRect Extents = ((CRaysView *)FindView( "Rays" ))->OutImg->Bounds();	
			BBitmap *OutImage = new BBitmap( BRect( 0, 0, Extents.Width(), Extents.Height() ), B_RGB_32_BIT );

			if(! ((CRaysView *)FindView( "Rays" )) )
				;
	
			if(! ((CRaysView *)FindView( "Rays" ))->OutImg )
					;
	

			OutImage->SetBits( ((CRaysView *)FindView( "Rays" ))->OutImg->Bits(),
							   ((CRaysView *)FindView( "Rays" ))->OutImg->BitsLength(),
							   0,
							   B_RGB_32_BIT
			 				);

			BTranslatorRoster *Roster = BTranslatorRoster::Default();
			BBitmapStream stream( OutImage );	
			BFile file( name, B_CREATE_FILE | B_WRITE_ONLY );
			Roster->Translate( &stream, NULL, NULL, &file, 0 );
		}
	}
}


/************************

///////////////////////////////////////////////////////////
// Save file.


void RaysWnd::SaveFile( BMessage *Message )
{
	entry_ref the_ref;
	const char *name;


	if( Message->FindRef( "directory", &the_ref ) < B_OK )
	{
	}
	else
	{
		if( Message->FindString( "name", (const char **) &name ) < B_OK )
		{
		}
		else
		{	
			FILE *fd = fopen( name, "w+b" );

			void *OutPtr = ((CRaysView *)FindView( "Rays" ))->OutImg->Bits();				
			BRect Extents = ((CRaysView *)FindView( "Rays" ))->OutImg->Bounds();
			int BPR = ((CRaysView *)FindView( "Rays" ))->OutImg->BytesPerRow();
			int rows = Extents.bottom - Extents.top;

		
			struct 
			{
				int16 Type;
				int32 Size;
				int16 res1;
				int16 res2;
				int32 Offset;
			}FileHeader;
			
			FileHeader.Type = 0x4d42;
			FileHeader.Size = 0;
			FileHeader.res1 = 0;
			FileHeader.res2 = 0;
			FileHeader.Offset = 54;
						
			// write out file header
			fwrite( &FileHeader, sizeof(FileHeader), 1, fd );			

//			char FileHeaderChar[ 14 ] = { 0x4d, 0x42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54 };
//			fwrite( &FileHeaderChar, sizeof(FileHeaderChar), 1, fd );
			
			// write out bitmap header.

			struct
			{
				int32 HeaderSize;
				int16 Witdh;
				int16 Height;
				int16 Planes;
				int16 BPS;
				
				int32 Compression;			
				int32 BitmapSize;
				int16 Horiz;
				int16 Vert;
				int32 Colours;
				int32 ColourRQ;
			} BMPHeader;
			
			
			BMPHeader.HeaderSize = 40;
			BMPHeader.Witdh = Extents.right -Extents.left;
			BMPHeader.Height = Extents.bottom - Extents.top;
			BMPHeader.Planes = 1;
			BMPHeader.BPS = 24;
				
			BMPHeader.Compression = 0;			
			BMPHeader.BitmapSize = BPR * BMPHeader.Height;
			BMPHeader.Horiz = 1000;	// This is bullshit.
			BMPHeader.Vert = 1000;
			BMPHeader.Colours = 1 << 24;
			BMPHeader.ColourRQ = 1 << 24;
		
			fwrite( &BMPHeader, sizeof( BMPHeader ), 1, fd );						
			

			// write out image data.	
			int result = fwrite( OutPtr, BPR, rows, fd );
						
						
			fclose( fd );	
		}
	}
}

**********************/

