
%{ 
int yyerror( char *s );
int yylex(); 

void MakeSphere( float x, float y, float z, float Rad, float R, float G, float B, float Amb, float Dif, float Bril, float Spec, float Rough, float Reflec ); 

float CurrX;
float CurrY;
float CurrZ;
float CurrA;
float CurrB;
float CurrC;
float CurrD;
float Radius;
float Red;
float Green;
float Blue;

float Ambient; 
float Diffuse;
float Brilliance;
float Specular;
float Roughness; 
float Reflection;

#define YYSTYPE double 
%}


%token SPHERE_ID OPEN_BRACKET_ID NUMBER_ID CLOSE_BRACKET_ID PLANE_ID BACKGROUND_ID COLOUR_ID PROP_ID

%start SCENE

%%

SCENE: OBJ
      | SCENE OBJ
      ; 

OBJ: SPHERE_OBJ | PLANE_OBJ | BACKGROUND_OBJ ;

BACKGROUND_OBJ:	BACKGROUND_ID NUMBER_ID NUMBER_ID NUMBER_ID ;

SPHERE_OBJ:	SPHERE_ID		{ 
					  Radius = 1.0; 
					  Red = 1.0f;
					  Green = 1.0f;
					  Blue = 1.0f;

					  Ambient = 0.5;
					  Diffuse = 0.5;
					  Brilliance = 0.5; 
				  	  Specular = 0.5;
					  Roughness = 0.5; 
					  Reflection = 0.1f;
					}

		OPEN_BRACKET_ID		{  }

		NUMBER_ID		{ 
					  CurrX = yylval;
					}
		NUMBER_ID		{ 
					  CurrY = yylval;
					}
		NUMBER_ID		{ 
					  CurrZ = yylval;
					}

		RADIUS		

		COLOUR_REF

		PROPERTIES

		CLOSE_BRACKET_ID	{ 
					  MakeSphere( CurrX, CurrY, CurrZ, 
							Radius,
							Red,
							Green,
							Blue, 
					  		Ambient,
							Diffuse,
							Brilliance,  
					  	        Specular,  
							Roughness,  
							Reflection
						);
					}
		;

COLOUR_REF:	COLOUR_VAL
		|
		;

COLOUR_VAL:		COLOUR_ID	{  }
		OPEN_BRACKET_ID		{ }
		NUMBER_ID		{ Red = yylval; }
		NUMBER_ID		{ Green = yylval; }
		NUMBER_ID		{ Blue = yylval; }
		CLOSE_BRACKET_ID	{ }
		;

RADIUS:		NUMBER_ID		{ Radius = yylval;  }
		|
		;

PROPERTIES:	PROP
		|
		;

PROP:		PROP_ID 		{ }
		OPEN_BRACKET_ID		{ }
		NUMBER_ID		{ Ambient = yylval;  }
		NUMBER_ID		{ Diffuse = yylval;  }
		NUMBER_ID		{ Brilliance = yylval;  }
		NUMBER_ID		{ Specular = yylval;  }
		NUMBER_ID		{ Roughness = yylval;  }
		NUMBER_ID		{ Reflection = yylval;  }
		CLOSE_BRACKET_ID	{ }
		;

PLANE_OBJ:	PLANE_ID 		{ }
		OPEN_BRACKET_ID 	{ }
		NUMBER_ID		{ 
					  CurrA = yylval;
					}
		NUMBER_ID		{ 
					  CurrB = yylval;
					}	

		NUMBER_ID		{ 
					  CurrC = yylval;
					}

		NUMBER_ID		{ 
					  CurrD = yylval;
					}
		CLOSE_BRACKET_ID 	{  }
		;


%%



#include "lex.yy.c"



yyerror( char *s )
{
	fprintf( stderr, "%s \n ", s );
	return 0;
}


