
%{ 
#include "RaysLang.tab.h" 
int yyerror( char *s ); 
int yywrap()
{
	return 1;
}

%}


SPHERE  		[Ss][Pp][Hh][Ee][Rr][Ee]	
PLANE			[Pp][Ll][Aa][Nn][Ee]
COLOUR			[Cc][Oo][Ll][Oo][Uu][Rr]
PROPERTIES		[Pp][Rr][Oo][Pp][Ee][Rr][Tt][Ii][Ee][Ss]
OPEN_BRACKET		"{"
CLOSE_BRACKET		"}"
NUMBER			-?[0-9]+.[0-9]+

%%
{PROPERTIES}	{ return PROP_ID; }	

{COLOUR}	{ return COLOUR_ID; } 

{SPHERE} 	{ return SPHERE_ID; }

{PLANE}		{ return PLANE_ID; }

{OPEN_BRACKET}	{ return OPEN_BRACKET_ID; }


{CLOSE_BRACKET}	{ return CLOSE_BRACKET_ID; }


{NUMBER}	{
			yylval = atof( yytext );
			return NUMBER_ID;
		}

[\n\t]		;
.		{ } 
%%

