//////////////////////////////////////////////////////////////////////
// Plane.cpp: implementation of the Plane class.
// Plane as in surface...
//////////////////////////////////////////////////////////////////////

#include "SceneObject.h"
#include "Plane.h"
#define EPSILON		1e-3


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Plane::Plane()
{
	// No valid default I can think of..
	A = B = C = Distance = 0.0;
}

Plane::Plane( float InA, float InB, float InC, float D )
{
	A = InA;
	B = InB;
	C = InC;
	Distance = -D;
}


double Plane::Intersect(Ray TheRay)
{
	double Result;
	double DotProdDir;
	double DotProdOrig;

	CVector Norm = Normal();					// Normal.
	~Norm;										// Normalise vector.

	DotProdDir = Norm % TheRay.Direction;		// Dot product..
	if( DotProdDir <= EPSILON )
		return 0.0;

	DotProdOrig = Norm % TheRay.Origin;			// Dot product.
	DotProdOrig += Distance;

	// Check for intersection behind ray origin.	
	Result = DotProdOrig / DotProdDir;
//	if( Result < 0.0 )
//		return 0.0;

	return Result;
}


//////////////////////////////////////////////////////////////////////
// The normal or up vector of a flat surface is the same anywhere along
// that flat surface. The input args are ignored and the normal is taken
// from the planes definition.
// This is the virtual function. 

CVector Plane::Normal( CVector Point )
{
	return CVector( A, B, C );
}


//////////////////////////////////////////////////////////////////////
// Non virtual overload with no arguments for cases that don't have an
// argument to pass anyway.

CVector Plane::Normal()
{
	return CVector( A, B, C );
}

