
//////////////////////////////////////////////////////////////////////
// MultithreadedMMXRender.h: interface for the CMultithreadedMMXRender class.
//

#ifndef MULTI_H
#define MULTI_H

#include "Ray.h"						// photon of light.
#include "ViewPoint.h"					// Camera pos, eye pos whatever.
#include "Colour.h"
#include "Image.h"
#include "SceneObject.h"				// Scene objects.
#include "LightSource.h"
#include "RaysDoc.h"
#include "RaysWnd.h"

class RaysWnd;

class CMultiRender  
{

public:
	// Rendering has a list of pointers to scean objects..

	BList *SceneList;
	BList *LightList;

	void MakeDefault( unsigned int Width,  unsigned int Height );
	
	void EmptyScene();			// Clears the scene.
	
	unsigned int nHeight;
	unsigned int nWidth;
	unsigned int RecurseLevel;
	void Shade( CSceneObject *ClosestObj, Ray TheRay, CVector  Normal, CVector Point,  CColour& col );
	void SetColour( int X, int Y, CImage& Image, CColour Value,  RaysWnd *MainWnd  );
	bool Trace( Ray& TheRay, CColour& RgbVal  );
	void MakeRay( int X, int Y, Ray& TheRay, ViewPoint EyePos );
	void Go( CRaysDoc *pDC, unsigned int Width, unsigned int Height, RaysWnd *MainWnd );
	CMultiRender();
	virtual ~CMultiRender();

	CColour Background;


private:
	CRaysDoc * pTheDoc;
};

#endif
