// LightSource.cpp: implementation of the CLightSource class.
//
//////////////////////////////////////////////////////////////////////

#include "Rays.h"
#include "SceneObject.h"
#include "Vector.h"
#include "LightSource.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

double CLightSource::Intersect(Ray ray)
{
	double RetVal = double( 0.0 );
	return RetVal;
}

CLightSource::CLightSource( CVector Origin )
{
	Center = Origin;
}


CColour CLightSource::GetColour( CSceneObject *ObjPtr, Ray LightRay, double Distance, BList *SceneList)
{
	CColour RetVal( 0.0f, 0.0f, 0.0f );

	////////////////////////////////////////////////////////////////
	// Iterate thru the scene objects list looking for objects 
	// between the object passed in and the light source..
	// Shadow .. black..	

	int pos;
	pos = 0;
	CSceneObject *CurrObject = NULL;

	if( !SceneList->IsEmpty() )											/// Not an empty scene..
	{		
		CurrObject = (CSceneObject *) SceneList->ItemAt( pos );			// Start at the begining.

		bool EndOfList = FALSE;
		while( ! EndOfList )
		{
			double InVal;

			if( CurrObject )											// Valid object ?	
			{
				InVal = CurrObject->Intersect( LightRay );				// Intersects ?
				if( (InVal >  (EPSILON ) ) && (InVal <  Distance ) )		// Closer ?
				{
					//if( CurrObject != ObjPtr )
						return RetVal;									// Darkness.
				}
			}
						
			// Not at end ? Then get the next object.
			CurrObject = (CSceneObject *) SceneList->ItemAt( pos );
			pos++;

			if( CurrObject == NULL )									// Is this the last object ?
				EndOfList = TRUE;

		}
	}



	////////////////////////////////////////////////////////////////
	// Has not intersected ergo return lights colour..

	RetVal = Properties.Colour;

	return RetVal;
}



double CLightSource::MakeLightRay(CVector Point, Ray& TheRay)
{
	double Distance;

	TheRay.Origin = Point;
	TheRay.Direction = Center - Point;
	Distance = TheRay.Direction.Length();
	~TheRay.Direction;					// Normalise operator.

	return Distance;
}


