//////////////////////////////////////////////////////////////////////
// Image.cpp: implementation of the CImage class.
//
//////////////////////////////////////////////////////////////////////

#include "Image.h"
#include <assert.h>				// asserting valid RGB channels.
#include <malloc.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CImage::CImage()
{
	RChannel = NULL;		// No memory allocated yet.
	GChannel = NULL;
	BChannel = NULL;
}

CImage::~CImage()
{
	if( RChannel )			// No memory leaks.
		free( RChannel );

	if( GChannel )
		free( GChannel );

	if( BChannel )
		free( BChannel );
}

void CImage::SetSize(int X, int Y)
{
	// Resize the matrix.
	Width = X;
	Height = Y;
	
	if( RChannel )
	{
		free( RChannel );
		RChannel = NULL;
	}

	if( GChannel )
	{
		free( GChannel );
		GChannel = NULL;
	}

	if( BChannel )
	{
		free( BChannel );
		BChannel = NULL;
	}

	RChannel = (unsigned char *) malloc( Y * (X + 1) );
	GChannel = (unsigned char *) malloc( Y * (X + 1) );
	BChannel = (unsigned char *) malloc( Y * (X + 1) );

	assert( RChannel );
	assert( GChannel );
	assert( BChannel );

	for( int CurrY = 0; CurrY < Y; CurrY++ )
	{
		for( int CurrX = 0; CurrX < X; CurrX++ )
		{
			*(RChannel + (Y * Width) + X) = 0;
			*(GChannel + (Y * Width) + X) = 0;
			*(BChannel + (Y * Width) + X) = 0;
		}
	}
}

void CImage::SetPixel(int X, int Y, CColour Value)
{
	// Need valid channels to write to.

	assert( RChannel );
	assert( GChannel );
	assert( BChannel );

	// Set value..
	*(RChannel + (Y * Width) + X) = Value.GetR(); 
	*(GChannel + (Y * Width) + X) = Value.GetG(); 
	*(BChannel + (Y * Width) + X) = Value.GetB(); 
}

////////////////////////////////////////////////////////////////////
// Returns a RGB value (Windows COLORREF) 
// for use in SetPixel()s, etc..

#define RGB( R, G, B ) ( R << 24 | G << 16 | B )
unsigned long CImage::GetValue(int X, int Y)
{	
	assert( RChannel );
	assert( GChannel );
	assert( BChannel );

	return RGB( *(RChannel + (Y * Width) + X), *(GChannel + (Y * Width) + X),	*(BChannel + (Y * Width) + X) );
}

////////////////////////////////////////////////////////////////////
/// Get size..

int CImage::GetWidth()
{
	return Width;
}

int CImage::GetHeight()
{
	return Height;
}
