//////////////////////////////////////////////////////////////////////
// Colour.h: interface for the Colour class.
//

#ifndef COLOUR_H
#define COLOUR_H
class CColour  
{
public:
	// Data setting
	void SetB( float InB );
	void SetG( float InG );
	void SetR( float InR );
	void SetB( unsigned char InB );
	void SetG( unsigned char InG );
	void SetR( unsigned char InR );

	 // Data access
	unsigned char GetG();
	unsigned char GetB();
	unsigned char GetR();


	/////////////////////////////////////////////////////////////////
	// RGB values in the range of 0 to 0xff. Typical colour channels. 
	unsigned char Red;
	unsigned char Green;
	unsigned char Blue;

	/////////////////////////////////////////////////////////////////
	// RGB values in the range of 0.0 to 1.0. 
	float Rval;
	float Gval;
	float Bval;

	CColour( float R, float G, float B );
	CColour( unsigned char R, unsigned char G, unsigned char B );
	CColour();

};

#endif
