//////////////////////////////////////////////////////////////////////
// Colour.cpp: implementation of the Colour class.
// Colours are managed in either 0.0 to 1.0 or 0 to 255 ranges.
// Conversion is automatic.

#include "Rays.h"
#include "Colour.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CColour::CColour()
{
	Red = Green = Blue = 0x0;
}

CColour::CColour( unsigned char R, unsigned char G, unsigned char B )
{
	Red = R;
	Green = G;
	Blue = B;

	// Constrain.
	if( Red > 0xff )
		Red = 0xff;

	if( Green > 0xff )
		Green = 0xff;

	if( Blue > 0xff )
		Blue = 0xff;

	// Convert from 0..255 to 0..1.0
	Rval = Red / 255.0f;
	Gval = Green / 255.0f;
	Bval = Blue / 255.0f;

}


//////////////////////////////////////////////////////////////////////
// CColour Class RGB()
//////////////////////////////////////////////////////////////////////


unsigned char CColour::GetR()
{
	return Red;
}

unsigned char CColour::GetG()
{
	return Green;
}


unsigned char CColour::GetB()
{
	return Blue;
}




CColour::CColour(float R, float G, float B)
{
	Rval = R;
	Gval = G;
	Bval = B;

	// Constrain.

	if( Rval > 1.0 )
		Rval = 1.0;

	if( Rval < 0.0 )
		Rval = 0.0;


	if( Gval > 1.0 )
		Gval = 1.0;

	if( Gval < 0.0 )
		Gval = 0.0;


	if( Bval > 1.0 )
		Bval = 1.0;

	if( Bval < 0.0 )
		Bval = 0.0;


	// Convert from 0.0 to 1.0 range to 0 to 255 range.
	Red = (unsigned char)( Rval * 255);
	Green = (unsigned char)( Gval * 255);
	Blue = (unsigned char)( Bval * 255 );
	
}


void CColour::SetR(unsigned char InR )
{
	Red = InR;

	// Convert from 0..255 to 0..1.0
	Rval = Red / 255.0f;
}

void CColour::SetG(unsigned char InG )
{
	Green = InG;
	// Convert from 0..255 to 0..1.0
	Gval = Green / 255.0f;
}

void CColour::SetB(unsigned char InB)
{
	Blue = InB;
	// Convert from 0..255 to 0..1.0
	Bval = Blue / 255.0f;
}

void CColour::SetR(float InR)
{
	Rval = InR;

	// Convert from 0.0 to 1.0 range to 0 to 255 range.
	Red = (unsigned char)( Rval * 255);

}

void CColour::SetG(float InG)
{
	Gval = InG;

	// Convert from 0.0 to 1.0 range to 0 to 255 range.
	Green = (unsigned char)( Gval * 255);
}

void CColour::SetB(float InB)
{
	Bval = InB;

	// Convert from 0.0 to 1.0 range to 0 to 255 range.
	Blue = (unsigned char)( Bval * 255 );
}
